<?php

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  Script: Maian Gallery v2.0
  Written by: David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: http://www.maianscriptworld.co.uk

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  
  This File: class_generic.inc.php
  Description: Generic Class

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


class genericOptions {

// Check if field data is valid..
function field_check($num,$num2,$data)
{
  if ($num2>0) {
   if ($data=="" || $data=="0" || $data=="http://" || strlen($data)<$num || strlen($data)>$num2) {
    return true;
   } else {
    return false;
   }
  }
  else
  {
    if ($data=="" || $data=="http://" || $data=="0") {
     return true;
    } else {
     return false;
    }
  }
}


// Check if e-mail field is valid..
function is_email_valid($email)
{
  if (!eregi("^([a-z]|[0-9]|\.|-|_)+@([a-z]|[0-9]|\.|-|_)+\.([a-z]|[0-9]){2,4}$", $email)) {
   return true;
  } else {
   return false;
  }
}

// Generates random alphanumeric string..
function random_data($num)
{
  $p = substr(md5(uniqid(rand(),1)), 3, $num);

  return strtoupper($p);
}

// Strip slashes if magic quotes are on..
function strip_slashes($data)
{
  return (get_magic_quotes_gpc() ? stripslashes($data) : $data);
}

// Return entities back to original form..
function char_back($data)
{
  return str_replace(array('&#039;','&quote;'),array('\'','"'),$data);
}

// Converts certain chars to character entities
function char_entities($data)
{
  return htmlspecialchars($data);
}

// Prevents SQL injection..
function safe_import($data)
{
  if (get_magic_quotes_gpc()) {
    $data = stripslashes($data);
  }
  return mysql_real_escape_string(trim($data));
}

// Clear post vars..
function clear_post_var($data)
{
  $data = '';
  
  return $data;
}

// Remove trailing slash from var if accidentally added..
function removeTrailingSlash($data)
{
  if (substr($data,-1)=='/') {
    return substr($data,0,strlen($data)-1);
  } else {
    return $data;
  }
}

// Define the client's browser type..
function get_browser_type()
{
  $USER_BROWSER_AGENT = "";

  if (ereg('OPERA(/| )([0-9].[0-9]{1,2})', strtoupper($_SERVER["HTTP_USER_AGENT"]), $log_version)) {
   $USER_BROWSER_AGENT = 'OPERA';
  } else if (ereg('MSIE ([0-9].[0-9]{1,2})',strtoupper($_SERVER["HTTP_USER_AGENT"]), $log_version)) {
   $USER_BROWSER_AGENT = 'IE';
  } else if (ereg('OMNIWEB/([0-9].[0-9]{1,2})', strtoupper($_SERVER["HTTP_USER_AGENT"]), $log_version)) {
   $USER_BROWSER_AGENT = 'OMNIWEB';
  } else if (ereg('MOZILLA/([0-9].[0-9]{1,2})', strtoupper($_SERVER["HTTP_USER_AGENT"]), $log_version)) {
   $USER_BROWSER_AGENT = 'MOZILLA';
  } else if (ereg('KONQUEROR/([0-9].[0-9]{1,2})', strtoupper($_SERVER["HTTP_USER_AGENT"]), $log_version)) {
   $USER_BROWSER_AGENT = 'KONQUEROR';
  } else {
   $USER_BROWSER_AGENT = 'OTHER';
  }

  return $USER_BROWSER_AGENT;
}
                
// Define MIME-TYPE according to target Browser..
function get_mime_type()
{
  $USER_BROWSER_AGENT = $this->get_browser_type();

  $mime_type = ($USER_BROWSER_AGENT == 'IE' || $USER_BROWSER_AGENT == 'OPERA')
  ? 'application/octetstream'
  : 'application/octet-stream';

  return $mime_type;
}

// Define new line character based on op system..
function define_newline()
{
  $newline = "\r\n";

  if (strstr(strtolower($_SERVER["HTTP_USER_AGENT"]), 'win')) {
    $newline = "\r\n";
  } else if (strstr(strtolower($_SERVER["HTTP_USER_AGENT"]), 'mac')) {
    $newline = "\r";
  } else {
    $newline = "\n";
  }

  return $newline;
}

}

?>
